/**
 * Write a description of class Banana here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import greenfoot.*;

public class Protagonist extends Actor
{    
    private int x = 500;
    private int y = 300;
    
    private int rotationSpeed = 9;
    private static int speed = 5;
    private int hp = 100;
    private int bulletCooldown = 3;
    private int bulletCooldownCounter = 0;
    private int grapeshotCooldown = 100;
    private int grapeshotCooldownCounter = 0;
    private int invincibilityFrames = 0;
    private boolean facingRight = true;
    private int tripleCooldownMax = 20;
    private int tripleCooldownCounter = 0;
    


    /**
     * Constructor for objects of class Banana
     */
    public Protagonist()
    {
        GreenfootImage i = this.getImage();
        i.scale(80, 80);
        this.setImage(i);
    }
    
    public void hitByEnemyCallback()
    {
        if (this.invincibilityFrames > 0) {
            return;
        }
        this.hp -= 20;
        invincibilityFrames = 50;
    }
    
    public void shootABullet()
    {
        int bulletSpeed = 10;
        Bullet bullet = new Bullet(bulletSpeed);
        getWorld().addObject(bullet, getX(), getY());
        bullet.init();
        bulletCooldownCounter = 0;
    }
    
    public void shootGrapeshot()
    {
        int bulletSpeed = 10;
        for (int angle = this.getRotation(); angle < 360 + this.getRotation(); angle += 45)
        {
            Bullet bullet = new Bullet(bulletSpeed);
            getWorld().addObject(bullet, getX(), getY());
            bullet.setRotation(angle);
        }
        grapeshotCooldownCounter = 0;
    }
    
    public void shootTripleMain()
    {
        tripleCooldownCounter++;
        if (tripleCooldownCounter >= tripleCooldownMax) {
            shootTriple();
        }
    }
    
    public void shootTriple()
    {
        int bulletSpeed = 10;
        for (int angle = -20; angle < 22; angle += 20)
        {
            Bullet bullet = new Bullet(bulletSpeed);
            getWorld().addObject(bullet, getX(), getY());
            MouseInfo m = Greenfoot.getMouseInfo();
            if (m == null)
                return;
            bullet.turnTowards(m.getX(), m.getY());
            bullet.setRotation(bullet.getRotation() + angle);
        }
        tripleCooldownCounter = 0;
    }
    
    public void updateBulletShooter()
    {
        bulletCooldownCounter++;
        if (bulletCooldownCounter < bulletCooldown)
            return;
        if (Greenfoot.getMouseInfo() != null && Greenfoot.getMouseInfo().getButton() == 1) {
            shootABullet();
        }
    }
    
    public void updateGrapeshot()
    {
        grapeshotCooldownCounter++;
        if (grapeshotCooldownCounter < grapeshotCooldown)
            return;
        if (Greenfoot.isKeyDown("q")) {
            shootGrapeshot();
        }
    }
    
    public static void setSpeed(int newSpeed)
    {
        speed = newSpeed;
    }
    
    private void flipHorizontally()
    {
        this.getImage().mirrorHorizontally();
    }
    
    private void faceLeft()
    {
        if (facingRight) {
            flipHorizontally();
            facingRight = false;
        }
    }
    
    private void faceRight()
    {
        if (!facingRight) {
            flipHorizontally();
            facingRight = true;
        }
    }
    
    @Override
    public void act()
    {
        if (Greenfoot.isKeyDown("a")) {
            this.x -= this.speed;
            faceLeft();
        }
        if (Greenfoot.isKeyDown("d")) {
            this.x += this.speed;
            faceRight();
        }
        if (Greenfoot.isKeyDown("w")) 
            this.y -= this.speed;
        if (Greenfoot.isKeyDown("s")) 
            this.y += this.speed;
        if (Greenfoot.isKeyDown("e"))
            shootTripleMain();
        updateBulletShooter();
        updateGrapeshot();
        shootTripleMain();
        
        invincibilityFrames--;
        if (invincibilityFrames > 0 && (invincibilityFrames / 5) % 2 == 0) {
            GreenfootImage i = this.getImage();
            i.scale(40, 40);
            this.setImage(i);
        } else {
            GreenfootImage i = this.getImage();
            i.scale(80, 80);
            this.setImage(i);
        }
        
        this.x = Math.max(0, Math.min(getWorld().getWidth (), this.x));
        this.y = Math.max(0, Math.min(getWorld().getHeight(), this.y));
        setLocation(this.x, this.y);
    }
    public void setHp(int amt){
        hp = amt;
    }
    public int getHp(){
        return hp;
    }

}
