import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.*;

/**
 * MyWorld - Main Game World
 */
public class MyWorld extends World
{
    private Protagonist theProtagonist;
    private static int enemiesKilled = 0;
    private static int enemiesKilledForStageToClear = 50;
    private int stage = 1;
    private long stageStartTime;
    private boolean gameOver = false;
    private boolean stageCleared = false;    
    public int framesPerEnemySpawn = 40;
    public int framesPerEnemyCoordinatorSpawn = 200;
    private boolean gameStarted = false;
    private boolean minimumEnemiesKilled = false;
    
    public MyWorld()
    {    
        super(1000, 600, 1); 
        stageStartTime = System.currentTimeMillis(); // Start timing the first stage
        theProtagonist = new Protagonist();
        this.addObject(theProtagonist, 500, 300);
        prepare();
    }
    
    public Protagonist protagonist()
    {
        return theProtagonist;
    }
    
    /**
     * Prepare the world for the start of the program.
     * That is: create the initial objects and add them to the world.
     */
    private void prepare()
    {
        restartMovements();
        enemiesKilled = 0;
        enemiesKilledForStageToClear = 50;
        enemiesKilled = 0;
        gameOver = false;
        stageCleared = false;    
        theProtagonist.setHp(100);
    }

        public void act()
    {
        if (stage == 3 && this.getObjects(Bingo.class).size() == 0) {
            this.addObject(new Bingo(), 500, 100);
            this.setBackground("darkdungeon.png");
        }
        if (this.getObjects(Bingo.class).size() != 0 && enemiesKilled >= 50
            && getObjects(Bingo.class).get(0).fightStage == 1) {
            getObjects(Bingo.class).get(0).goToStage2();
        }
        if(!gameStarted){
            showText("Main Menu", 500, 300);
            //setBackground("something");
            showText("Press space to restart", 500, 350);
            if(Greenfoot.isKeyDown("space")){
                gameStarted = true;
                showText("", 500, 300);
                //setBackground("something");
                showText("", 500, 350);
            }
            return;
        }
        if (!gameOver && !stageCleared)
        {
            if (!minimumEnemiesKilled){
                spawnEnemy();
                enemyCoordinator();
            }
            updateHUD();
        }
        checkGameOver();
        checkStageCleared();
        if (gameOver && Greenfoot.isKeyDown("space")) {
            resetEverything();
        }
    }
    public void spawnEnemy()
    {
        if (stage == 3) return;
        if ((int)Math.floor(Math.random() * framesPerEnemySpawn) == 0) {
            createOneEnemy();
        }
    }    
    
    public void createOneEnemy()
    {
        int enemyX, enemyY;
        if (Math.random() < 1 / 2) {
            enemyX = (int)Math.floor(Math.random() * 2) * this.getWidth();
            enemyY = (int)Math.floor(Math.random() * this.getHeight());
        } else {
            enemyX = (int)Math.floor(Math.random() * this.getWidth());
            enemyY = (int)Math.floor(Math.random() * 2) * this.getHeight();
        }
        
        this.addObject(new Enemy(true, true), enemyX, enemyY);
    }
    
    public void enemyCoordinator(){   
        if (stage == 3) return;    
        if ((int)Math.floor(Math.random() * framesPerEnemyCoordinatorSpawn) == 0) {
        //if (Greenfoot.isKeyDown("k")) {
            boolean isACircle = Math.random() < 0.5;
            boolean isASquare = !isACircle;
            this.addObject(new EnemyCoordinator(isACircle, isASquare, 7), 0, 0);
        }
    }
    private void updateHUD()
    {
        // Display HP
        showText("HP: " + theProtagonist.getHp(), 100, 20);

        // Display Enemies Killed
        showText("Enemies Killed: " + enemiesKilled, 300, 20);

        // Display Elapsed Time
        long elapsedTime = (System.currentTimeMillis() - stageStartTime) / 1000;
        showText("Time: " + elapsedTime + " seconds", 500, 20);

        // Display Stage
        showText("Stage: " + stage, 700, 20);
    }
    private void checkGameOver()
    {
        if (theProtagonist.getHp() <= 0 && !gameOver )
        {
            gameOver = true;
            showText("GAME OVER", 500, 300);
            showText("Press space to restart", 500, 350);
            resetEverything();
            stageStartTime = System.currentTimeMillis();

            if(Greenfoot.isKeyDown("space")){
                prepare();
                showText("", 500, 300);
                showText("", 500, 350);
            }
        }
    }
    
    private void resetEverything()
    {
        clearWorld();
        restartMovements(); 
        stage = 1;
        framesPerEnemySpawn = 40;
        framesPerEnemyCoordinatorSpawn = 200;
        gameOver = false;
    }
    
    private void checkStageCleared()
    {
        if (getObjects(Bingo.class).size() != 0) {
            return; // Stage isn't cleared if Bingo is still alive
        }
        if (enemiesKilled >= enemiesKilledForStageToClear){
            minimumEnemiesKilled = true;
        }
        if (minimumEnemiesKilled && getObjects(Enemy.class).size() ==0 && !stageCleared)
        {
            stageCleared = true;
            minimumEnemiesKilled = false;
            long stageEndTime = System.currentTimeMillis();
            stopMovements();
            showText("STAGE CLEARED! Time: " + (stageEndTime - stageStartTime) / 1000 + " seconds", getWidth() / 2, getHeight() / 2);
            showText("Press space to continue", getWidth() / 2, getHeight() / 2 + 50);
        }
        if (stageCleared && Greenfoot.isKeyDown("space"))
        {
            nextStage();
            showText("", getWidth() / 2, getHeight() / 2);
            showText("", getWidth() / 2, getHeight() / 2 + 50);
        }
    }
    private void nextStage()
    {
        stage++;
        stageCleared = false;
        minimumEnemiesKilled = false;
        framesPerEnemySpawn = framesPerEnemySpawn / 2;
        framesPerEnemyCoordinatorSpawn = framesPerEnemyCoordinatorSpawn / 2;
        if (stage <= 3)
        { 
            enemiesKilledForStageToClear += 10; // Increase difficulty
            enemiesKilled = 0;
            restartMovements(); 
            stageStartTime = System.currentTimeMillis(); // Start timing the next stage
            prepare();
        } 
        else
        {
            endGame();
        }
    }
     private void clearWorld()
    {
        removeObjects(getObjects(Enemy.class));
        removeObjects(getObjects(Bullet.class));
        removeObjects(getObjects(EnemyBullet.class));
    }
    private void endGame()
    {
        stopMovements();
        showText("CONGRATULATIONS! GAME COMPLETE", getWidth() / 2, getHeight() / 2);
        showText("Thank you for playing!", getWidth() / 2, getHeight() / 2 + 50);
        Greenfoot.stop();
    }
    public void stopMovements(){
        Enemy.setSpeed(0);
        EnemyBullet.setSpeed(0);
        Protagonist.setSpeed(0);
        Bullet.setSpeed(0);
    }
    public void restartMovements(){
        Enemy.setSpeed(3);
        EnemyBullet.setSpeed(5);
        Protagonist.setSpeed(5);
        Bullet.setSpeed(10);
    }
    public static void incrementEnemiesKilled()
    {
        enemiesKilled++;
    }
}
