/**
 * Write a description of class EnemyCoordinator here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
import greenfoot.*;
import java.util.*;

public class EnemyCoordinator extends Actor
{
    ArrayList<Enemy> mySprites = new ArrayList<Enemy>();
    boolean isACircle;
    boolean isASquare;
    private int n;

    /**
     * Constructor for objects of class EnemyCoordinator
     */
    public EnemyCoordinator(boolean isACircle, boolean isASquare, int n)
    {
        this.isACircle = isACircle;
        this.isASquare = isASquare;
        this.n = n;
    }
    
    public void addedToWorld(World world)
    {
        
        Protagonist p = world.getObjects(Protagonist.class).get(0);
        int x = p.getX();
        int y = p.getY();
        
        if (isACircle) {
            double distance = 400.0;
            double changeInAngle = 360.0 / this.n;
            double currentAngle = 0.0;
            
            for (int i = 0; i < this.n; i++) {
                int nx = x + (int) Math.floor(distance * Math.cos(currentAngle / 180.0 * Math.PI));
                int ny = y + (int) Math.floor(distance * Math.sin(currentAngle / 180.0 * Math.PI));
                Enemy e = new Enemy(false, false);
                e.setRotation((int)(currentAngle + 180.0) % 360);
                world.addObject(e, nx, ny);
                this.mySprites.add(e);
                currentAngle += changeInAngle;
            }
        } 
        if (isASquare) {
            // square of enemies!!!
            int[][] positions = {{400, 0}, {400, 400}, {0, 400}, {-400, 400}, {-400, 0}, {-400, -400}, {0, -400}, {400, -400}};
            for (int[] position : positions) {
                int nx = position[0] + x;
                int ny = position[1] + y;
                Enemy e = new Enemy(false, false);
                world.addObject(e, nx, ny);
                e.turnTowards(x, y);
                this.mySprites.add(e);
            }
        }
    }
    
    public void act()
    {
        for (Enemy e : mySprites) {
            e.moveForwards();
        }
    }
}
