/**
 * Write a description of class EnemyBullet here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import greenfoot.*;

public class EnemyBullet extends Actor
{
    private static int speed;
    
    public EnemyBullet(int speed) 
    {
        this.speed = speed;
        GreenfootImage i = this.getImage();
        i.scale(40, 40);
        this.setImage(i);
    }
    
    public static void setSpeed(int newSpeed){
        speed = newSpeed;
    }
    public double distanceToPlayer()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        return Math.sqrt(Math.pow(p.getX() - this.getX(), 2) +
                      Math.pow(p.getY() - this.getY(), 2));

    }
      
    private void killThePlayerIfWeTouchedIt()
    {
        Protagonist protagonistThatWeAreTouching = (Protagonist) getOneIntersectingObject(Protagonist.class);
        if (protagonistThatWeAreTouching == null) {
            return;
        }
        if (this.distanceToPlayer() > 30) {
            return;
        }
        protagonistThatWeAreTouching.hitByEnemyCallback();
    }
    
    public void init()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        
        turnTowards(p.getX(), p.getY());
    }
    
    public void act()
    {
        move(speed);
        killThePlayerIfWeTouchedIt();
        if (isAtEdge()) {
            getWorld().removeObject(this);
        }
    }
}
