/**
 * Write a description of class Enemy here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
  

import greenfoot.*;

public class Enemy extends Actor
{
    // instance variables - replace the example below with your own
    private int x;
    private static int speed = 3;
    private int framesSinceLastShot = 0;
    private int framesPerShot = 40;
    private boolean canMove;
    private boolean canShoot;

    /**
     * Constructor for objects of class Enemy
     */
    public Enemy(boolean canMove, boolean canShoot)
    {
        this.canMove  = canMove;
        this.canShoot = canShoot;
        
        if (canMove && canShoot) {
            if (Math.random() < 0.5) {
                this.setImage("spade.png");
            } else {
                this.setImage("heart.png");
            }
            this.getImage().scale(50, 50);
        } else {
            this.getImage().scale(100, 100);
        }
        
        
    }
    
    @Override
    public void addedToWorld(World world)
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        if (this.distanceToPlayer() < 100) {
            world.removeObject(this);
        }
        GreenfootImage i = this.getImage();
        i.scale(100, 100);
        this.setImage(i);
    }
    
    public double distanceToPlayer()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        return Math.sqrt(Math.pow(p.getX() - this.getX(), 2) +
                      Math.pow(p.getY() - this.getY(), 2));
        
    }
    
    private void moveTowardsThePlayer()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        turnTowards(p.getX(), p.getY());
        move(this.speed);
    }
    
    private void killThePlayerIfWeTouchedIt()
    {
        Protagonist protagonistThatWeAreTouching = (Protagonist) getOneIntersectingObject(Protagonist.class);
        if (protagonistThatWeAreTouching == null) {
            return;
        }
        protagonistThatWeAreTouching.hitByEnemyCallback();
    }
    
    private void dieIfWeGotShot()
    {
        Bullet bulletThatWeAreTouching = (Bullet) getOneIntersectingObject(Bullet.class);
        if (bulletThatWeAreTouching == null) {
            return;
        }
        MyWorld.incrementEnemiesKilled();
        getWorld().removeObject(bulletThatWeAreTouching);
        getWorld().removeObject(this);
    }
    
    private void shootAtThePlayer()
    {
        framesSinceLastShot++;
        if (framesSinceLastShot < framesPerShot) {
            return;
        }
        EnemyBullet b = new EnemyBullet(5);
        getWorld().addObject(b, this.getX(), this.getY());
        b.setRotation(this.getRotation());        
        framesSinceLastShot = 0;
    }
    public static void setSpeed(int newSpeed){
        speed = newSpeed;
    }
    public void moveForwards()
    {
        move(speed);
    }
    
    @Override
    public void act()
    {
        if (canMove) {
            moveTowardsThePlayer();
        }
        if (canShoot) {
            shootAtThePlayer();
        }   
        killThePlayerIfWeTouchedIt();
        dieIfWeGotShot();
    }
}
