/**
 * Write a description of class Bullet here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import greenfoot.*;

public class Bullet extends Actor
{
    private static int speed;
    
    public Bullet(int speed) 
    {
        this.speed = speed;
        
        GreenfootImage i = this.getImage();
        i.scale(40, 40);
        this.setImage(i);
    }
    
    public void init()
    {
        MouseInfo mouseInfo = Greenfoot.getMouseInfo();
        int mouseX = mouseInfo.getX();
        int mouseY = mouseInfo.getY();
        
        turnTowards(mouseX, mouseY);
    }
    
    public static void setSpeed(int newSpeed){
        speed = newSpeed;
    }
    
    public void act()
    {
        move(speed);
        boolean destroyedAnyEnemyBullets = false;
        for (EnemyBullet b : getIntersectingObjects(EnemyBullet.class))
        {
            getWorld().removeObject(b);
            destroyedAnyEnemyBullets = true;
        }
        if (destroyedAnyEnemyBullets)
        {
            getWorld().removeObject(this);
        }
        else if (isAtEdge()) {
            getWorld().removeObject(this);
        }
    }
}
