/**
 * Write a description of class Bingo here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
  

import greenfoot.*;

public class Bingo extends Actor
{
    private static int speed = 3;
    private int framesSinceLastShot = 0;
    private int framesPerShot = 20;
    
    public int fightStage = 1;
    private int framesSinceLastEC = 0;
    private int framesPerEC = 40;
    
    private boolean goingDown = true;
    private int x2 = 40;
    private int y2 = 40;
    private double f2Speed = 2.0;
    private boolean slowingDown = false;
    
    private double angle = 0;
    private double radius = 200;
    private boolean radiusIncreasing = true;
    private int counter = 0;
    

    /**
     * Constructor for objects of class Bingo
     */
    public Bingo()
    {
        
    }
    
    public void fightStage1()
    {
        framesSinceLastEC++;
        if (framesSinceLastEC >= framesPerEC) {
            getWorld().addObject(
                new EnemyCoordinator(true, false, (int)Math.ceil(Math.random() * 15)), 
                0, 
                0
            );
            framesSinceLastEC = 0;
        }
    }
    
    public void goToStage2()
    {
        fightStage = 2;
    }
    
    public void createOneEnemy()
    {
        int enemyX, enemyY;
        if (Math.random() < 1 / 2) {
            enemyX = (int)Math.floor(Math.random() * 2) * getWorld().getWidth();
            enemyY = (int)Math.floor(Math.random() * getWorld().getHeight());
        } else {
            enemyX = (int)Math.floor(Math.random() * getWorld().getWidth());
            enemyY = (int)Math.floor(Math.random() * 2) * getWorld().getHeight();
        }
        
        getWorld().addObject(new Enemy(true, true), enemyX, enemyY);
    }
    
    public void fightStage2()
    {
        f2Speed += slowingDown ? -0.01 : 0.01;
        framesPerShot = slowingDown ? 0 : 20 - (int)(f2Speed);
        if (framesPerShot == 0)
            slowingDown = true;
        y2 += goingDown ? (int)(f2Speed) : -(int)(f2Speed);
        if (y2 > getWorld().getHeight()) {
            goingDown = false;
        }
        if (y2 < 0) {
            goingDown = true;
        }
        if (Math.random() < 0.01) {
            createOneEnemy();
        }
        setLocation(x2, y2);
        shootAtThePlayer();
        if (f2Speed < 0.0) {
            this.fightStage = 3;
            return;
        }
    }
    
    public void fightStage3()
    {
        framesPerShot = 2;
        counter++;
        Protagonist p = (Protagonist) getWorld().getObjects(Protagonist.class).get(0);
        int nx = (int)(radius * Math.sin(angle / 180 * Math.PI)) + 500;
        int ny = (int)(radius * Math.cos(angle / 180 * Math.PI)) + 300;
        
        
        if (radius < -300 && radiusIncreasing == false)
            radiusIncreasing = true;
        if (radius > 300 && radiusIncreasing == true)
            radiusIncreasing = false;
        
        radius += radiusIncreasing ? 1 : -2;
        angle += 2;
        setLocation(nx, ny);
        
        shootAtThePlayerDirect();
        
        if (Math.random() < 0.02) {
            createOneEnemy();
        }
        
        if (counter == 1000)
            protagonistWinsTheGame();
    }
    
    public void protagonistWinsTheGame()
    {
        getWorld().setBackground("youwin.png");
        Greenfoot.stop();
    }
    
    @Override
    public void act()
    {
        switch (fightStage) {
            case 1:
                fightStage1();
                return;
            case 2:
                fightStage2();
                return;
            case 3:
                fightStage3();
                return;
        }
    }
    
    @Override
    public void addedToWorld(World world)
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        if (this.distanceToPlayer() < 100) {
            world.removeObject(this);
        }
        GreenfootImage i = this.getImage();
        i.scale(100, 100);
        this.setImage(i);
    }
    
    public double distanceToPlayer()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        return Math.sqrt(Math.pow(p.getX() - this.getX(), 2) +
                      Math.pow(p.getY() - this.getY(), 2));
        
    }
    
    private void moveTowardsThePlayer()
    {
        Protagonist p = getWorld().getObjects(Protagonist.class).get(0);
        turnTowards(p.getX(), p.getY());
        move(this.speed);
    }
    
    private void killThePlayerIfWeTouchedIt()
    {
        Protagonist protagonistThatWeAreTouching = (Protagonist) getOneIntersectingObject(Protagonist.class);
        if (protagonistThatWeAreTouching == null) {
            return;
        }
        protagonistThatWeAreTouching.hitByEnemyCallback();
    }
    
    private void dieIfWeGotShot()
    {
        ; // BINGO IS IMMORTAL
        /*Bullet bulletThatWeAreTouching = (Bullet) getOneIntersectingObject(Bullet.class);
        if (bulletThatWeAreTouching == null) {
            return;
        }
        MyWorld.incrementEnemiesKilled();
        getWorld().removeObject(bulletThatWeAreTouching);
        getWorld().removeObject(this);*/
    }
    
    private void shootAtThePlayer()
    {
        framesSinceLastShot++;
        if (framesSinceLastShot < framesPerShot) {
            return;
        }
        EnemyBullet b = new EnemyBullet(5);
        getWorld().addObject(b, this.getX(), this.getY());
        b.setRotation(this.getRotation());        
        framesSinceLastShot = 0;
    }
    
    private void shootAtThePlayerDirect()
    {
        framesSinceLastShot++;
        if (framesSinceLastShot < framesPerShot) {
            return;
        }
        EnemyBullet b = new EnemyBullet(5);
        getWorld().addObject(b, this.getX(), this.getY());
        b.init();
        framesSinceLastShot = 0;
    }
}
